/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex;

import ink.ptms.artifex.ArtScriptCompiler;
import ink.ptms.artifex.ArtScriptCompilerKt;
import ink.ptms.artifex.kotlin.KotlinCompilationConfiguration;
import ink.ptms.artifex.script.ScriptCompilationPool;
import ink.ptms.artifex.script.ScriptCompiled;
import ink.ptms.artifex.script.ScriptCompiler;
import ink.ptms.artifex.script.ScriptResult;
import ink.ptms.artifex.script.ScriptRuntimeProperty;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Link/ptms/artifex/ArtScriptCompilationPool;", "Link/ptms/artifex/script/ScriptCompilationPool;", "builder", "Link/ptms/artifex/ArtScriptCompiler$BuilderImpl;", "(Link/ptms/artifex/ArtScriptCompiler$BuilderImpl;)V", "getBuilder", "()Link/ptms/artifex/ArtScriptCompiler$BuilderImpl;", "pool", "Ljava/util/concurrent/ExecutorService;", "getPool", "()Ljava/util/concurrent/ExecutorService;", "size", "Ljava/util/concurrent/atomic/AtomicInteger;", "getSize", "()Ljava/util/concurrent/atomic/AtomicInteger;", "compile", "Ljava/util/concurrent/CompletableFuture;", "Link/ptms/artifex/script/ScriptCompiled;", "sourceCode", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Link/ptms/artifex/script/ScriptCompiler$Configuration;", "isCompleted", "", "submit", "file", "Ljava/io/File;", "property", "Link/ptms/artifex/script/ScriptRuntimeProperty;", "main", "", "inputStream", "Ljava/io/InputStream;", "byteArray", "", "source", "common-core"})
@SourceDebugExtension(value={"SMAP\nArtScriptCompilationPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtScriptCompilationPool.kt\nink/ptms/artifex/ArtScriptCompilationPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class ArtScriptCompilationPool
implements ScriptCompilationPool {
    @NotNull
    private final ArtScriptCompiler.BuilderImpl builder;
    @NotNull
    private final AtomicInteger size;
    @NotNull
    private final ExecutorService pool;

    public ArtScriptCompilationPool(@NotNull ArtScriptCompiler.BuilderImpl builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.size = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        Intrinsics.checkNotNull((Object)executorService);
        this.pool = executorService;
    }

    @NotNull
    public final ArtScriptCompiler.BuilderImpl getBuilder() {
        return this.builder;
    }

    @NotNull
    public final AtomicInteger getSize() {
        return this.size;
    }

    @NotNull
    public final ExecutorService getPool() {
        return this.pool;
    }

    @Override
    public boolean isCompleted() {
        return this.size.get() == 0;
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull File file, @NotNull ScriptCompiler.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return this.compile(ArtScriptCompilerKt.toSourceCode(file), configuration);
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull File file, @NotNull ScriptRuntimeProperty property) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.compile(ArtScriptCompilerKt.toSourceCode(file), new KotlinCompilationConfiguration(property));
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull String source, @NotNull ScriptCompiler.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return this.compile(ArtScriptCompilerKt.toSourceCode(source, main2), configuration);
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull String source, @NotNull ScriptRuntimeProperty property) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.compile(ArtScriptCompilerKt.toSourceCode(source, main2), new KotlinCompilationConfiguration(property));
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull byte[] byteArray, @NotNull ScriptCompiler.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        byte[] byArray = byteArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return this.compile(ArtScriptCompilerKt.toSourceCode(new String(byArray, charset2), main2), configuration);
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull byte[] byteArray, @NotNull ScriptRuntimeProperty property) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        byte[] byArray = byteArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return this.compile(ArtScriptCompilerKt.toSourceCode(new String(byArray, charset2), main2), new KotlinCompilationConfiguration(property));
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull InputStream inputStream, @NotNull ScriptCompiler.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return this.compile(ArtScriptCompilerKt.toSourceCode(new String(byArray, charset2), main2), configuration);
    }

    @Override
    @NotNull
    public CompletableFuture<ScriptCompiled> submit(@NotNull String main2, @NotNull InputStream inputStream, @NotNull ScriptRuntimeProperty property) {
        Intrinsics.checkNotNullParameter((Object)main2, (String)"main");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return this.compile(ArtScriptCompilerKt.toSourceCode(new String(byArray, charset2), main2), new KotlinCompilationConfiguration(property));
    }

    @NotNull
    public final CompletableFuture<ScriptCompiled> compile(@NotNull SourceCode sourceCode, @NotNull ScriptCompiler.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CompletableFuture<ScriptCompiled> future = new CompletableFuture<ScriptCompiled>();
        this.size.incrementAndGet();
        this.pool.submit(() -> ArtScriptCompilationPool.compile$lambda$3(this, configuration, sourceCode, future));
        return future;
    }

    private static final void compile$lambda$3(ArtScriptCompilationPool this$0, ScriptCompiler.Configuration $configuration, SourceCode $sourceCode, CompletableFuture $future) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
            Intrinsics.checkNotNullParameter((Object)$sourceCode, (String)"$sourceCode");
            Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
            try {
                ScriptCompiled scriptCompiled;
                ScriptCompiled it;
                ArtScriptCompiler.CompilerImpl compilerImpl;
                ArtScriptCompiler.CompilerImpl compilerImpl2 = compilerImpl = new ArtScriptCompiler.CompilerImpl();
                ArtScriptCompiler artScriptCompiler = ArtScriptCompiler.INSTANCE;
                boolean bl = false;
                ((ArtScriptCompiler.CompilerImpl)((Object)it)).setConfiguration($configuration);
                ((ArtScriptCompiler.CompilerImpl)((Object)it)).setSource($sourceCode);
                Consumer<ScriptResult.Diagnostic> consumer = this$0.builder.getOnReport();
                if (consumer != null) {
                    Consumer<ScriptResult.Diagnostic> r = consumer;
                    boolean bl2 = false;
                    ((ArtScriptCompiler.CompilerImpl)((Object)it)).setOnReport(r);
                }
                if ((scriptCompiled = artScriptCompiler.compile(compilerImpl)) != null) {
                    it = scriptCompiled;
                    boolean bl3 = false;
                    $future.complete(it);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            if (this$0.size.decrementAndGet() != 0) break block5;
            Runnable runnable = this$0.builder.getOnCompleted();
            if (runnable != null) {
                runnable.run();
            }
        }
    }
}

