/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script;

import ink.ptms.artifex.script.ScriptSourceCode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\n\u000b\f\rJ\b\u0010\u0003\u001a\u00020\u0004H&J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Link/ptms/artifex/script/ScriptResult;", "R", "", "isSuccessful", "", "reports", "", "Link/ptms/artifex/script/ScriptResult$Diagnostic;", "value", "()Ljava/lang/Object;", "Diagnostic", "Result", "Severity", "Source", "common"})
public interface ScriptResult<R> {
    @Nullable
    public R value();

    @NotNull
    public List<Diagnostic> reports();

    public boolean isSuccessful();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J=\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010!\u001a\u00020\u001eJ\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Link/ptms/artifex/script/ScriptResult$Diagnostic;", "", "code", "", "message", "", "severity", "Link/ptms/artifex/script/ScriptResult$Severity;", "source", "Link/ptms/artifex/script/ScriptResult$Source;", "exception", "", "(ILjava/lang/String;Link/ptms/artifex/script/ScriptResult$Severity;Link/ptms/artifex/script/ScriptResult$Source;Ljava/lang/Throwable;)V", "getCode", "()I", "getException", "()Ljava/lang/Throwable;", "getMessage", "()Ljava/lang/String;", "getSeverity", "()Link/ptms/artifex/script/ScriptResult$Severity;", "getSource", "()Link/ptms/artifex/script/ScriptResult$Source;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "isIgnored", "toString", "common"})
    public static final class Diagnostic {
        private final int code;
        @NotNull
        private final String message;
        @NotNull
        private final Severity severity;
        @NotNull
        private final Source source;
        @Nullable
        private final Throwable exception;

        public Diagnostic(int code, @NotNull String message, @NotNull Severity severity, @NotNull Source source, @Nullable Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.code = code;
            this.message = message;
            this.severity = severity;
            this.source = source;
            this.exception = exception;
        }

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final Source getSource() {
            return this.source;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }

        public final boolean isIgnored() {
            return this.severity == Severity.DEBUG || StringsKt.contains$default((CharSequence)this.message, (CharSequence)"never used", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.message, (CharSequence)"deprecated", (boolean)false, (int)2, null);
        }

        @NotNull
        public String toString() {
            String string;
            String pos;
            ScriptSourceCode.Location loc = this.source.getLocation();
            String string2 = pos = loc != null ? "(Line: " + loc.getStart().getLine() + ", Column: " + loc.getStart().getCol() + "): " : "";
            if (this.source.getPath() != null) {
                String path = StringsKt.substringAfterLast$default((String)this.source.getPath(), (char)'/', null, (int)2, null);
                string = (Object)((Object)this.severity) + ": " + pos + this.message + " (" + path + ')';
            } else {
                string = (Object)((Object)this.severity) + ": " + pos + this.message;
            }
            return string;
        }

        public final int component1() {
            return this.code;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final Severity component3() {
            return this.severity;
        }

        @NotNull
        public final Source component4() {
            return this.source;
        }

        @Nullable
        public final Throwable component5() {
            return this.exception;
        }

        @NotNull
        public final Diagnostic copy(int code, @NotNull String message, @NotNull Severity severity, @NotNull Source source, @Nullable Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new Diagnostic(code, message, severity, source, exception);
        }

        public static /* synthetic */ Diagnostic copy$default(Diagnostic diagnostic, int n, String string, Severity severity, Source source, Throwable throwable, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = diagnostic.code;
            }
            if ((n2 & 2) != 0) {
                string = diagnostic.message;
            }
            if ((n2 & 4) != 0) {
                severity = diagnostic.severity;
            }
            if ((n2 & 8) != 0) {
                source = diagnostic.source;
            }
            if ((n2 & 0x10) != 0) {
                throwable = diagnostic.exception;
            }
            return diagnostic.copy(n, string, severity, source, throwable);
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.code);
            result2 = result2 * 31 + this.message.hashCode();
            result2 = result2 * 31 + this.severity.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            result2 = result2 * 31 + (this.exception == null ? 0 : this.exception.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Diagnostic)) {
                return false;
            }
            Diagnostic diagnostic = (Diagnostic)other;
            if (this.code != diagnostic.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)diagnostic.message)) {
                return false;
            }
            if (this.severity != diagnostic.severity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)diagnostic.source)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exception, (Object)diagnostic.exception);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u001f\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Link/ptms/artifex/script/ScriptResult$Result;", "", "scriptClass", "Ljava/lang/Class;", "instance", "(Ljava/lang/Class;Ljava/lang/Object;)V", "getInstance", "()Ljava/lang/Object;", "getScriptClass", "()Ljava/lang/Class;", "Error", "NotEvaluated", "Unit", "Value", "Link/ptms/artifex/script/ScriptResult$Result$Error;", "Link/ptms/artifex/script/ScriptResult$Result$NotEvaluated;", "Link/ptms/artifex/script/ScriptResult$Result$Unit;", "Link/ptms/artifex/script/ScriptResult$Result$Value;", "common"})
    public static abstract class Result {
        @Nullable
        private final Class<?> scriptClass;
        @Nullable
        private final Object instance;

        private Result(Class<?> scriptClass, Object instance) {
            this.scriptClass = scriptClass;
            this.instance = instance;
        }

        @Nullable
        public final Class<?> getScriptClass() {
            return this.scriptClass;
        }

        @Nullable
        public final Object getInstance() {
            return this.instance;
        }

        public /* synthetic */ Result(Class scriptClass, Object instance, DefaultConstructorMarker $constructor_marker) {
            this(scriptClass, instance);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Link/ptms/artifex/script/ScriptResult$Result$Error;", "Link/ptms/artifex/script/ScriptResult$Result;", "error", "", "wrappingException", "scriptClass", "Ljava/lang/Class;", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/lang/Class;)V", "getError", "()Ljava/lang/Throwable;", "getWrappingException", "toString", "", "common"})
        public static final class Error
        extends Result {
            @NotNull
            private final Throwable error;
            @Nullable
            private final Throwable wrappingException;

            public Error(@NotNull Throwable error, @Nullable Throwable wrappingException, @Nullable Class<?> scriptClass) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(scriptClass, null, null);
                this.error = error;
                this.wrappingException = wrappingException;
            }

            public /* synthetic */ Error(Throwable throwable, Throwable throwable2, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable2 = null;
                }
                if ((n & 4) != 0) {
                    clazz = null;
                }
                this(throwable, throwable2, clazz);
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            @Nullable
            public final Throwable getWrappingException() {
                return this.wrappingException;
            }

            @NotNull
            public String toString() {
                this.error.printStackTrace();
                return this.error.toString();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Link/ptms/artifex/script/ScriptResult$Result$NotEvaluated;", "Link/ptms/artifex/script/ScriptResult$Result;", "()V", "common"})
        public static final class NotEvaluated
        extends Result {
            @NotNull
            public static final NotEvaluated INSTANCE = new NotEvaluated();

            private NotEvaluated() {
                super(null, null, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Link/ptms/artifex/script/ScriptResult$Result$Unit;", "Link/ptms/artifex/script/ScriptResult$Result;", "scriptClass", "Ljava/lang/Class;", "instance", "", "(Ljava/lang/Class;Ljava/lang/Object;)V", "toString", "", "common"})
        public static final class Unit
        extends Result {
            public Unit(@NotNull Class<?> scriptClass, @Nullable Object instance) {
                Intrinsics.checkNotNullParameter(scriptClass, (String)"scriptClass");
                super(scriptClass, instance, null);
            }

            @NotNull
            public String toString() {
                return "Unit";
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Link/ptms/artifex/script/ScriptResult$Result$Value;", "Link/ptms/artifex/script/ScriptResult$Result;", "name", "", "value", "", "type", "scriptClass", "Ljava/lang/Class;", "instance", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getType", "getValue", "()Ljava/lang/Object;", "toString", "common"})
        public static final class Value
        extends Result {
            @NotNull
            private final String name;
            @Nullable
            private final Object value;
            @NotNull
            private final String type;

            public Value(@NotNull String name, @Nullable Object value, @NotNull String type, @Nullable Class<?> scriptClass, @Nullable Object instance) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                super(scriptClass, instance, null);
                this.name = name;
                this.value = value;
                this.type = type;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final Object getValue() {
                return this.value;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            @NotNull
            public String toString() {
                return this.name + ": " + this.type + " = " + this.value;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Link/ptms/artifex/script/ScriptResult$Severity;", "", "color", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getColor", "()Ljava/lang/String;", "DEBUG", "INFO", "WARNING", "ERROR", "FATAL", "common"})
    public static final class Severity
    extends Enum<Severity> {
        @NotNull
        private final String color;
        public static final /* enum */ Severity DEBUG = new Severity("\u00a78");
        public static final /* enum */ Severity INFO = new Severity("\u00a77");
        public static final /* enum */ Severity WARNING = new Severity("\u00a76");
        public static final /* enum */ Severity ERROR = new Severity("\u00a7c");
        public static final /* enum */ Severity FATAL = new Severity("\u00a74");
        private static final /* synthetic */ Severity[] $VALUES;

        private Severity(String color) {
            this.color = color;
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String value) {
            return Enum.valueOf(Severity.class, value);
        }

        static {
            $VALUES = severityArray = new Severity[]{Severity.DEBUG, Severity.INFO, Severity.WARNING, Severity.ERROR, Severity.FATAL};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Link/ptms/artifex/script/ScriptResult$Source;", "", "path", "", "location", "Link/ptms/artifex/script/ScriptSourceCode$Location;", "(Ljava/lang/String;Link/ptms/artifex/script/ScriptSourceCode$Location;)V", "getLocation", "()Link/ptms/artifex/script/ScriptSourceCode$Location;", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "common"})
    public static final class Source {
        @Nullable
        private final String path;
        @Nullable
        private final ScriptSourceCode.Location location;

        public Source(@Nullable String path, @Nullable ScriptSourceCode.Location location) {
            this.path = path;
            this.location = location;
        }

        @Nullable
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final ScriptSourceCode.Location getLocation() {
            return this.location;
        }

        @Nullable
        public final String component1() {
            return this.path;
        }

        @Nullable
        public final ScriptSourceCode.Location component2() {
            return this.location;
        }

        @NotNull
        public final Source copy(@Nullable String path, @Nullable ScriptSourceCode.Location location) {
            return new Source(path, location);
        }

        public static /* synthetic */ Source copy$default(Source source, String string, ScriptSourceCode.Location location, int n, Object object) {
            if ((n & 1) != 0) {
                string = source.path;
            }
            if ((n & 2) != 0) {
                location = source.location;
            }
            return source.copy(string, location);
        }

        @NotNull
        public String toString() {
            return "Source(path=" + this.path + ", location=" + this.location + ')';
        }

        public int hashCode() {
            int result2 = this.path == null ? 0 : this.path.hashCode();
            result2 = result2 * 31 + (this.location == null ? 0 : this.location.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Source)) {
                return false;
            }
            Source source = (Source)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)source.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.location, (Object)source.location);
        }
    }
}

