/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script.impl;

import ink.ptms.artifex.script.FileSet;
import ink.ptms.artifex.script.ScriptProject;
import ink.ptms.artifex.script.ScriptProjectConstructor;
import ink.ptms.artifex.script.ScriptProjectIdentifier;
import ink.ptms.artifex.script.ZipsKt;
import ink.ptms.artifex.script.impl.DefaultReleasedScriptProject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import taboolib.common.platform.function.IOKt;
import taboolib.module.configuration.Configuration;
import taboolib.module.configuration.Type;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Link/ptms/artifex/script/impl/DefaultReleasedIdentifier;", "Link/ptms/artifex/script/ScriptProjectIdentifier$ReleasedIdentifier;", "zip", "Ljava/util/zip/ZipInputStream;", "(Ljava/util/zip/ZipInputStream;)V", "fileSet", "Link/ptms/artifex/script/FileSet;", "getFileSet", "()Link/ptms/artifex/script/FileSet;", "root", "Ltaboolib/module/configuration/Configuration;", "getRoot", "()Ltaboolib/module/configuration/Configuration;", "setRoot", "(Ltaboolib/module/configuration/Configuration;)V", "getZip", "()Ljava/util/zip/ZipInputStream;", "load", "Link/ptms/artifex/script/ScriptProject;", "name", "", "Constructor", "common-impl-project"})
public final class DefaultReleasedIdentifier
implements ScriptProjectIdentifier.ReleasedIdentifier {
    @NotNull
    private final ZipInputStream zip;
    @NotNull
    private final FileSet fileSet;
    @Nullable
    private Configuration root;

    public DefaultReleasedIdentifier(@NotNull ZipInputStream zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        this.zip = zip;
        this.fileSet = ZipsKt.toFileSet(this.zip);
        byte[] byArray = this.getFileSet().get("project.yml");
        if (byArray == null) {
            throw new IllegalStateException("project.yml not found".toString());
        }
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        this.root = Configuration.Companion.loadFromString$default((Configuration.Companion)Configuration.Companion, (String)new String(byArray2, charset2), (Type)Type.YAML, (boolean)false, (int)4, null);
    }

    @NotNull
    public final ZipInputStream getZip() {
        return this.zip;
    }

    @Override
    @NotNull
    public FileSet getFileSet() {
        return this.fileSet;
    }

    @Nullable
    public final Configuration getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable Configuration configuration) {
        this.root = configuration;
    }

    @Override
    @NotNull
    public String name() {
        Configuration configuration = this.root;
        Intrinsics.checkNotNull((Object)configuration);
        return String.valueOf(configuration.getString("name"));
    }

    @Override
    @NotNull
    public Configuration root() {
        Configuration configuration = this.root;
        Intrinsics.checkNotNull((Object)configuration);
        return configuration;
    }

    @Override
    @NotNull
    public ScriptProject load() {
        return new DefaultReleasedScriptProject(this, new Constructor(this));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0013\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Link/ptms/artifex/script/impl/DefaultReleasedIdentifier$Constructor;", "Link/ptms/artifex/script/ScriptProjectConstructor;", "identifier", "Link/ptms/artifex/script/impl/DefaultReleasedIdentifier;", "(Link/ptms/artifex/script/impl/DefaultReleasedIdentifier;)V", "getIdentifier", "()Link/ptms/artifex/script/impl/DefaultReleasedIdentifier;", "dataFolder", "Ljava/io/File;", "files", "", "", "get", "", "name", "has", "", "common-impl-project"})
    public static final class Constructor
    extends ScriptProjectConstructor {
        @NotNull
        private final DefaultReleasedIdentifier identifier;

        public Constructor(@NotNull DefaultReleasedIdentifier identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            this.identifier = identifier;
        }

        @NotNull
        public final DefaultReleasedIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        @NotNull
        public File dataFolder() {
            return new File(IOKt.getDataFolder().getParentFile(), this.identifier.name());
        }

        @Override
        @NotNull
        public Set<String> files() {
            return this.identifier.getFileSet().files();
        }

        @Override
        public boolean has(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.identifier.getFileSet().has(name);
        }

        @Override
        @Nullable
        public byte[] get(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.identifier.getFileSet().get(name);
        }
    }
}

