/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script.impl;

import ink.ptms.artifex.script.Script;
import ink.ptms.artifex.script.ScriptContainer;
import ink.ptms.artifex.script.ScriptContainerManager;
import ink.ptms.artifex.script.ScriptUtlsKt;
import ink.ptms.artifex.script.impl.DefaultScriptContainer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR)\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001a"}, d2={"Link/ptms/artifex/script/impl/DefaultScriptContainerManager;", "Link/ptms/artifex/script/ScriptContainerManager;", "()V", "activeScriptContainers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Link/ptms/artifex/script/ScriptContainer;", "getActiveScriptContainers", "()Ljava/util/concurrent/ConcurrentHashMap;", "activeScriptMap", "", "", "getActiveScriptMap", "createContainer", "script", "Link/ptms/artifex/script/Script;", "get", "id", "getAll", "", "getExchangeData", "name", "register", "resetExchangeData", "", "unregister", "common-impl-default"})
public final class DefaultScriptContainerManager
implements ScriptContainerManager {
    @NotNull
    private final ConcurrentHashMap<String, ScriptContainer> activeScriptContainers = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Object>> activeScriptMap = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, ScriptContainer> getActiveScriptContainers() {
        return this.activeScriptContainers;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, Object>> getActiveScriptMap() {
        return this.activeScriptMap;
    }

    @Override
    @NotNull
    public ScriptContainer createContainer(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return new DefaultScriptContainer(script);
    }

    @Override
    @NotNull
    public ScriptContainer register(@NotNull ScriptContainer script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ((Map)this.activeScriptContainers).put(ScriptUtlsKt.scriptName(script), script);
        return script;
    }

    @Override
    public void unregister(@NotNull ScriptContainer script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.activeScriptContainers.remove(ScriptUtlsKt.scriptName(script));
    }

    @Override
    @Nullable
    public ScriptContainer get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.activeScriptContainers.get(id);
    }

    @Override
    @NotNull
    public List<ScriptContainer> getAll() {
        Collection<ScriptContainer> collection = this.activeScriptContainers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"activeScriptContainers.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> getExchangeData(@NotNull String name) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.activeScriptMap.containsKey(name)) {
            Map map2 = this.activeScriptMap.get(name);
            Intrinsics.checkNotNull(map2);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"{\n            activeScriptMap[name]!!\n        }");
            map = map2;
        } else {
            void var2_2;
            ConcurrentHashMap map3 = new ConcurrentHashMap();
            ((Map)this.activeScriptMap).put(name, map3);
            map = (Map)var2_2;
        }
        return map;
    }

    @Override
    public void resetExchangeData(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.activeScriptMap.remove(name);
    }
}

