/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script.impl;

import ink.ptms.artifex.Artifex;
import ink.ptms.artifex.script.Script;
import ink.ptms.artifex.script.ScriptContainer;
import ink.ptms.artifex.script.ScriptMeta;
import ink.ptms.artifex.script.ScriptProject;
import ink.ptms.artifex.script.ScriptProjectConstructor;
import ink.ptms.artifex.script.ScriptProjectIdentifier;
import ink.ptms.artifex.script.ScriptRuntimeProperty;
import ink.ptms.artifex.script.ScriptSimpleEvaluator;
import ink.ptms.artifex.script.ScriptTaskEvaluator;
import ink.ptms.artifex.script.event.ScriptEvent;
import ink.ptms.artifex.script.event.ScriptProjectReleasedEvent;
import ink.ptms.artifex.script.event.ScriptProjectReloadedEvent;
import ink.ptms.artifex.script.event.ScriptProjectStartedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import taboolib.common.platform.ProxyCommandSender;
import taboolib.module.configuration.Configuration;
import taboolib.module.lang.LangKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H&J \u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000e2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020\bH&J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020\bH\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140)H\u0016J\u001d\u0010\u0012\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010*2\u0006\u0010+\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010,J\u0018\u0010\u0012\u001a\u00020-2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\u0018\u00100\u001a\u00020-2\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u00020\bH\u0016J\u0018\u00102\u001a\u00020-2\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u00020\bH\u0016J \u00103\u001a\u00020-2\u0006\u0010#\u001a\u00020$2\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u00020\bH\u0016J \u00106\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\b\u00107\u001a\u00020-H\u0016J\b\u00108\u001a\u000209H\u0016J \u0010:\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\u0018\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u000eH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u001b\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 0\u001fj\b\u0012\u0004\u0012\u00020 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Link/ptms/artifex/script/impl/DefaultScriptProject;", "Link/ptms/artifex/script/ScriptProject;", "identifier", "Link/ptms/artifex/script/ScriptProjectIdentifier;", "constructor", "Link/ptms/artifex/script/ScriptProjectConstructor;", "(Link/ptms/artifex/script/ScriptProjectIdentifier;Link/ptms/artifex/script/ScriptProjectConstructor;)V", "autoMount", "", "getAutoMount", "()Z", "getConstructor", "()Link/ptms/artifex/script/ScriptProjectConstructor;", "dependencies", "", "", "getDependencies", "()Ljava/util/List;", "exchangeData", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getIdentifier", "()Link/ptms/artifex/script/ScriptProjectIdentifier;", "main", "getMain", "repositories", "getRepositories", "runningId", "getRunningId", "()Ljava/lang/String;", "runningScripts", "Ljava/util/ArrayList;", "Link/ptms/artifex/script/Script;", "Lkotlin/collections/ArrayList;", "checkScripts", "sender", "Ltaboolib/common/platform/ProxyCommandSender;", "collectScripts", "Link/ptms/artifex/script/ScriptMeta;", "forceCompile", "disabled", "", "T", "name", "(Ljava/lang/String;)Ljava/lang/Object;", "", "value", "isRunning", "release", "logging", "releaseAll", "releaseScript", "container", "Link/ptms/artifex/script/ScriptContainer;", "reload", "reloadConfig", "root", "Ltaboolib/module/configuration/Configuration;", "run", "runScript", "scriptMeta", "common-impl-project"})
@SourceDebugExtension(value={"SMAP\nDefaultScriptProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultScriptProject.kt\nink/ptms/artifex/script/impl/DefaultScriptProject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1855#2,2:248\n1855#2,2:250\n1855#2,2:252\n*S KotlinDebug\n*F\n+ 1 DefaultScriptProject.kt\nink/ptms/artifex/script/impl/DefaultScriptProject\n*L\n123#1:248,2\n152#1:250,2\n230#1:252,2\n*E\n"})
public abstract class DefaultScriptProject
implements ScriptProject {
    @NotNull
    private final ScriptProjectIdentifier identifier;
    @NotNull
    private final ScriptProjectConstructor constructor;
    @NotNull
    private final ConcurrentHashMap<String, Object> exchangeData;
    @NotNull
    private final ArrayList<Script> runningScripts;
    @NotNull
    private final String runningId;

    public DefaultScriptProject(@NotNull ScriptProjectIdentifier identifier, @NotNull ScriptProjectConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.identifier = identifier;
        this.constructor = constructor;
        this.exchangeData = new ConcurrentHashMap();
        this.runningScripts = new ArrayList();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.runningId = string;
    }

    @NotNull
    public final ScriptProjectIdentifier getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final ScriptProjectConstructor getConstructor() {
        return this.constructor;
    }

    @NotNull
    public final String getRunningId() {
        return this.runningId;
    }

    @NotNull
    public final List<String> getMain() {
        return this.identifier.root().getStringList("main");
    }

    @NotNull
    public final List<String> getRepositories() {
        return this.identifier.root().getStringList("repositories");
    }

    @NotNull
    public final List<String> getDependencies() {
        return this.identifier.root().getStringList("dependencies");
    }

    public final boolean getAutoMount() {
        return this.identifier.root().getBoolean("auto-mount");
    }

    public abstract boolean checkScripts(@NotNull ProxyCommandSender var1);

    @NotNull
    public abstract List<ScriptMeta> collectScripts(@NotNull ProxyCommandSender var1, boolean var2);

    public static /* synthetic */ List collectScripts$default(DefaultScriptProject defaultScriptProject, ProxyCommandSender proxyCommandSender, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectScripts");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return defaultScriptProject.collectScripts(proxyCommandSender, bl);
    }

    @Override
    @NotNull
    public String runningId() {
        return this.runningId;
    }

    @Override
    @NotNull
    public List<Script> runningScripts() {
        return this.runningScripts;
    }

    @Override
    public boolean disabled() {
        return this.identifier.root().getBoolean("disable");
    }

    @Override
    @NotNull
    public Configuration root() {
        return this.identifier.root();
    }

    @Override
    @NotNull
    public String name() {
        return this.identifier.name();
    }

    @Override
    @NotNull
    public ScriptProjectConstructor constructor() {
        return this.constructor;
    }

    @Override
    public boolean run(@NotNull ProxyCommandSender sender, boolean forceCompile, boolean logging) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        if (this.checkScripts(sender)) {
            List<ScriptMeta> scripts;
            if (logging) {
                Object[] objectArray = new Object[]{this.name()};
                LangKt.sendLang((ProxyCommandSender)sender, (String)"project-start", (Object[])objectArray);
            }
            if ((scripts = this.collectScripts(sender, forceCompile)).isEmpty()) {
                return false;
            }
            if (Artifex.INSTANCE.api().getScriptProjectManager().getRunningProject(this.name()) == null) {
                Artifex.INSTANCE.api().getScriptProjectManager().applyProject(this);
            }
            Object[] $this$forEach$iv = (Object[])scripts;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                ScriptMeta it = (ScriptMeta)t;
                boolean bl = false;
                this.runScript(it, sender);
            }
            if (logging) {
                $this$forEach$iv = new Object[]{this.name()};
                LangKt.sendLang((ProxyCommandSender)sender, (String)"command-project-started", (Object[])$this$forEach$iv);
            }
            ScriptProjectStartedEvent event = new ScriptProjectStartedEvent(this, sender, scripts, logging, forceCompile);
            Artifex.INSTANCE.api().getScriptEventBus().call((ScriptEvent)event);
            return true;
        }
        return false;
    }

    @Override
    public boolean reload(@NotNull ProxyCommandSender sender, boolean forceCompile, boolean logging) {
        List<ScriptMeta> scripts;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        if (logging) {
            Object[] objectArray = new Object[]{this.name()};
            LangKt.sendLang((ProxyCommandSender)sender, (String)"project-reload", (Object[])objectArray);
        }
        if ((scripts = this.collectScripts(sender, forceCompile)).isEmpty()) {
            return false;
        }
        this.releaseAll(sender, false);
        Object[] $this$forEach$iv = (Object[])scripts;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            ScriptMeta it = (ScriptMeta)t;
            boolean bl = false;
            this.runScript(it, sender);
        }
        if (logging) {
            $this$forEach$iv = new Object[]{this.name()};
            LangKt.sendLang((ProxyCommandSender)sender, (String)"command-project-reloaded", (Object[])$this$forEach$iv);
        }
        ScriptProjectReloadedEvent event = new ScriptProjectReloadedEvent(this, sender, scripts, logging, forceCompile);
        Artifex.INSTANCE.api().getScriptEventBus().call((ScriptEvent)event);
        return true;
    }

    @Override
    public void release(@NotNull ProxyCommandSender sender, boolean logging) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        if (logging) {
            objectArray = new Object[]{this.name()};
            LangKt.sendLang((ProxyCommandSender)sender, (String)"project-release", (Object[])objectArray);
        }
        this.releaseAll(sender, logging);
        Artifex.INSTANCE.api().getScriptProjectManager().releaseProject(this.name());
        if (logging) {
            objectArray = new Object[]{this.name()};
            LangKt.sendLang((ProxyCommandSender)sender, (String)"command-project-released", (Object[])objectArray);
        }
        ScriptProjectReleasedEvent event = new ScriptProjectReleasedEvent(this, sender, logging);
        Artifex.INSTANCE.api().getScriptEventBus().call((ScriptEvent)event);
    }

    @Override
    public boolean isRunning() {
        return !((Collection)this.runningScripts).isEmpty();
    }

    @Override
    public void reloadConfig() {
        this.identifier.root().reload();
    }

    @Override
    @Nullable
    public <T> T exchangeData(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.exchangeData.get(name);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public void exchangeData(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.exchangeData).put(name, value);
    }

    @Override
    @NotNull
    public Map<String, Object> exchangeData() {
        return this.exchangeData;
    }

    public void runScript(@NotNull ScriptMeta scriptMeta, @NotNull ProxyCommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)scriptMeta, (String)"scriptMeta");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Map<String, Object> data = Artifex.INSTANCE.api().getScriptContainerManager().getExchangeData(this.runningId);
        data.put("@Project", this);
        ScriptTaskEvaluator.apply$default(ScriptSimpleEvaluator.prepareEvaluation$default(Artifex.INSTANCE.api().getScriptHelper().getSimpleEvaluator(), scriptMeta, sender, false, false, null, 24, null).loggingMounted(false).mount(this.getAutoMount()).afterEval(arg_0 -> DefaultScriptProject.runScript$lambda$2(this, arg_0)), new ScriptRuntimeProperty(MapsKt.mapOf((Pair)TuplesKt.to((Object)"@Id", (Object)this.runningId)), MapsKt.emptyMap()), null, 2, null);
    }

    public void releaseAll(@NotNull ProxyCommandSender sender, boolean logging) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Iterable $this$forEach$iv = this.runningScripts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Script it = (Script)element$iv;
            boolean bl = false;
            this.releaseScript(sender, it.container(), logging);
        }
        this.runningScripts.clear();
        this.exchangeData.clear();
        Artifex.INSTANCE.api().getScriptContainerManager().resetExchangeData(this.runningId);
    }

    public void releaseScript(@NotNull ProxyCommandSender sender, @NotNull ScriptContainer container, boolean logging) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (logging) {
            Artifex.INSTANCE.api().getScriptHelper().releaseScript(container, sender, true);
        } else {
            container.releaseSafely(true);
        }
    }

    private static final void runScript$lambda$2(DefaultScriptProject this$0, Script it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.runningScripts).add(it);
        it.container().exchangeData().put("@Project", this$0);
    }
}

