/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script.impl;

import ink.ptms.artifex.Artifex;
import ink.ptms.artifex.script.ScriptCompiled;
import ink.ptms.artifex.script.ScriptHelper;
import ink.ptms.artifex.script.ScriptMetaHandler;
import ink.ptms.artifex.script.ScriptRuntimeProperty;
import ink.ptms.artifex.script.ScriptSimpleCompiler;
import ink.ptms.artifex.script.ScriptSource;
import ink.ptms.artifex.script.ScriptTaskCompiler;
import ink.ptms.artifex.script.event.ScriptCompileCheckEvent;
import ink.ptms.artifex.script.event.ScriptEvent;
import ink.ptms.artifex.script.impl.TaskCompiler;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import taboolib.common.io.FileCreateKt;
import taboolib.common.io.FileDigestKt;
import taboolib.common.platform.ProxyCommandSender;
import taboolib.module.lang.LangKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J>\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016JL\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Link/ptms/artifex/script/impl/DefaultScriptSimpleCompiler;", "Link/ptms/artifex/script/ScriptSimpleCompiler;", "()V", "helper", "Link/ptms/artifex/script/ScriptHelper;", "getHelper", "()Link/ptms/artifex/script/ScriptHelper;", "metaHandler", "Link/ptms/artifex/script/ScriptMetaHandler;", "getMetaHandler", "()Link/ptms/artifex/script/ScriptMetaHandler;", "compileByProvidedProperties", "Link/ptms/artifex/script/ScriptCompiled;", "script", "Ljava/io/File;", "sender", "Ltaboolib/common/platform/ProxyCommandSender;", "providedProperties", "", "", "", "loggingBefore", "", "save", "detailError", "compileByText", "compileCheck", "file", "logging", "forceCompile", "prepareCompile", "Link/ptms/artifex/script/impl/TaskCompiler;", "Link/ptms/artifex/script/ScriptSource;", "loggingCompile", "prepare", "Ljava/lang/Runnable;", "common-impl-default"})
@SourceDebugExtension(value={"SMAP\nDefaultScriptSimpleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultScriptSimpleCompiler.kt\nink/ptms/artifex/script/impl/DefaultScriptSimpleCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class DefaultScriptSimpleCompiler
implements ScriptSimpleCompiler {
    private final ScriptHelper getHelper() {
        return Artifex.INSTANCE.api().getScriptHelper();
    }

    private final ScriptMetaHandler getMetaHandler() {
        return Artifex.INSTANCE.api().getScriptMetaHandler();
    }

    @Override
    @NotNull
    public TaskCompiler prepareCompile(@NotNull ScriptSource script, @NotNull ProxyCommandSender sender, boolean loggingCompile, boolean detailError, @NotNull Runnable prepare) {
        TaskCompiler taskCompiler;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)prepare, (String)"prepare");
        TaskCompiler it = taskCompiler = new TaskCompiler(script, sender, detailError, loggingCompile);
        boolean bl = false;
        prepare.run();
        return taskCompiler;
    }

    @Override
    @Nullable
    public ScriptCompiled compileByText(@NotNull String script, @NotNull ProxyCommandSender sender, @NotNull Map<String, ? extends Object> providedProperties, boolean loggingBefore, boolean detailError) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(providedProperties, (String)"providedProperties");
        return ScriptTaskCompiler.apply$default(ScriptSimpleCompiler.prepareCompile$default(this, Artifex.INSTANCE.api().getScriptCompiler().toScriptSource("main", script), sender, false, detailError, () -> DefaultScriptSimpleCompiler.compileByText$lambda$1(loggingBefore, sender), 4, null), ScriptRuntimeProperty.Companion.fromProvidedProperties(providedProperties), null, 2, null);
    }

    @Override
    @Nullable
    public ScriptCompiled compileByProvidedProperties(@NotNull File script, @NotNull ProxyCommandSender sender, @NotNull Map<String, ? extends Object> providedProperties, boolean loggingBefore, boolean save, boolean detailError) {
        ScriptCompiled compiled;
        block1: {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter(providedProperties, (String)"providedProperties");
            compiled = ScriptTaskCompiler.apply$default(ScriptSimpleCompiler.prepareCompile$default(this, Artifex.INSTANCE.api().getScriptCompiler().toScriptSource(script), sender, false, detailError, () -> DefaultScriptSimpleCompiler.compileByProvidedProperties$lambda$2(loggingBefore, sender, providedProperties), 4, null), ScriptRuntimeProperty.Companion.fromProvidedProperties(providedProperties), null, 2, null);
            if (!save) break block1;
            ScriptCompiled scriptCompiled = compiled;
            if (scriptCompiled != null) {
                scriptCompiled.generateScriptJar(FileCreateKt.newFile$default((File)this.getHelper().buildFolder(), (String)(FilesKt.getNameWithoutExtension((File)script) + ".jar"), (boolean)false, (boolean)false, (int)12, null));
            }
        }
        return compiled;
    }

    @Override
    public boolean compileCheck(@NotNull File file, @NotNull ProxyCommandSender sender, @NotNull Map<String, ? extends Object> providedProperties, boolean logging, boolean forceCompile, boolean save, boolean detailError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(providedProperties, (String)"providedProperties");
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"kts")) {
            throw new IllegalStateException("Not a kts file".toString());
        }
        File buildFile = new File(this.getHelper().buildFolder(), FilesKt.getNameWithoutExtension((File)file) + ".jar");
        if (buildFile.exists() && !forceCompile) {
            String string;
            try {
                string = this.getMetaHandler().getScriptVersion(buildFile);
            }
            catch (Throwable ex) {
                if (logging) {
                    Object[] objectArray = new Object[]{String.valueOf(ex.getMessage())};
                    LangKt.sendLang((ProxyCommandSender)sender, (String)"command-script-error", (Object[])objectArray);
                }
                string = null;
            }
            String version = string;
            if (version != null) {
                String currentVersion = this.getHelper().getScriptVersion(Artifex.INSTANCE.api().getScriptCompiler().toScriptSource(file), providedProperties);
                if (!Intrinsics.areEqual((Object)FileDigestKt.digest$default((File)file, null, (int)1, null), (Object)this.getHelper().getFixedScriptVersion()) && !Intrinsics.areEqual((Object)currentVersion, (Object)version)) {
                    if (logging) {
                        Object[] ex = new Object[]{version, currentVersion};
                        LangKt.sendLang((ProxyCommandSender)sender, (String)"command-script-recompiled", (Object[])ex);
                    }
                    if (this.compileByProvidedProperties(file, sender, providedProperties, logging, save, detailError) == null) {
                        return false;
                    }
                }
                ScriptCompileCheckEvent event = new ScriptCompileCheckEvent(file, sender, providedProperties, logging, save, detailError, buildFile, version, currentVersion);
                Artifex.INSTANCE.api().getScriptEventBus().call((ScriptEvent)event);
                if (event.getRecompile() && this.compileByProvidedProperties(file, sender, providedProperties, logging, save, detailError) == null) {
                    return false;
                }
                return event.getCheckResult();
            }
            if (this.compileByProvidedProperties(file, sender, providedProperties, logging, save, detailError) == null) {
                return false;
            }
        } else {
            if (!forceCompile && logging) {
                LangKt.sendLang((ProxyCommandSender)sender, (String)"command-script-compile", (Object[])new Object[0]);
            }
            if (this.compileByProvidedProperties(file, sender, providedProperties, logging, save, detailError) == null) {
                return false;
            }
        }
        return true;
    }

    private static final void compileByText$lambda$1(boolean $loggingBefore, ProxyCommandSender $sender) {
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        if ($loggingBefore) {
            LangKt.sendLang((ProxyCommandSender)$sender, (String)"command-script-shell-compile", (Object[])new Object[0]);
        }
    }

    private static final void compileByProvidedProperties$lambda$2(boolean $loggingBefore, ProxyCommandSender $sender, Map $providedProperties) {
        Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
        Intrinsics.checkNotNullParameter((Object)$providedProperties, (String)"$providedProperties");
        if ($loggingBefore) {
            Object[] objectArray = new Object[]{$providedProperties};
            LangKt.sendLang((ProxyCommandSender)$sender, (String)"command-script-compile-info", (Object[])objectArray);
        }
    }
}

