/*
 * Decompiled with CFR 0.152.
 */
package ink.ptms.artifex.script.impl;

import ink.ptms.artifex.Artifex;
import ink.ptms.artifex.script.ScriptCompileFailedException;
import ink.ptms.artifex.script.ScriptCompiled;
import ink.ptms.artifex.script.ScriptCompiler;
import ink.ptms.artifex.script.ScriptFileSource;
import ink.ptms.artifex.script.ScriptResult;
import ink.ptms.artifex.script.ScriptRuntimeProperty;
import ink.ptms.artifex.script.ScriptSource;
import ink.ptms.artifex.script.ScriptTaskCompiler;
import ink.ptms.artifex.script.event.ScriptCompileEvent;
import ink.ptms.artifex.script.event.ScriptEvent;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import taboolib.common.platform.ProxyCommandSender;
import taboolib.common.platform.function.ExecutorKt;
import taboolib.common.platform.service.PlatformExecutor;
import taboolib.module.lang.LangKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Link/ptms/artifex/script/impl/TaskCompiler;", "Link/ptms/artifex/script/ScriptTaskCompiler;", "script", "Link/ptms/artifex/script/ScriptSource;", "sender", "Ltaboolib/common/platform/ProxyCommandSender;", "loggingCompile", "", "detailError", "(Link/ptms/artifex/script/ScriptSource;Ltaboolib/common/platform/ProxyCommandSender;ZZ)V", "future", "Ljava/util/concurrent/CompletableFuture;", "Link/ptms/artifex/script/ScriptCompiled;", "time", "", "apply", "property", "Link/ptms/artifex/script/ScriptRuntimeProperty;", "report", "Ljava/util/function/Consumer;", "Link/ptms/artifex/script/ScriptResult$Diagnostic;", "startLogger", "", "common-impl-default"})
public final class TaskCompiler
implements ScriptTaskCompiler {
    @NotNull
    private final ScriptSource script;
    @NotNull
    private final ProxyCommandSender sender;
    private final boolean loggingCompile;
    private final boolean detailError;
    private final long time;
    @NotNull
    private final CompletableFuture<ScriptCompiled> future;

    public TaskCompiler(@NotNull ScriptSource script, @NotNull ProxyCommandSender sender, boolean loggingCompile, boolean detailError) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        this.script = script;
        this.sender = sender;
        this.loggingCompile = loggingCompile;
        this.detailError = detailError;
        this.time = System.currentTimeMillis();
        this.future = new CompletableFuture();
    }

    @Override
    @Nullable
    public ScriptCompiled apply(@NotNull ScriptRuntimeProperty property, @Nullable Consumer<ScriptResult.Diagnostic> report) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.script instanceof ScriptFileSource && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)((ScriptFileSource)this.script).getFile()), (Object)"kts")) {
            return null;
        }
        ScriptCompileEvent event = new ScriptCompileEvent(this.script, this.sender, this.loggingCompile, this.detailError, this.time, property);
        Artifex.INSTANCE.api().getScriptEventBus().call((ScriptEvent)event);
        if (event.isCancelled()) {
            return null;
        }
        if (this.loggingCompile) {
            this.startLogger();
        }
        return Artifex.INSTANCE.api().getScriptCompiler().compile(arg_0 -> TaskCompiler.apply$lambda$3(this, property, report, arg_0));
    }

    public final void startLogger() {
        PlatformExecutor.PlatformTask task2 = ExecutorKt.submit$default((boolean)false, (boolean)true, (long)20L, (long)20L, (Function1)((Function1)new Function1<PlatformExecutor.PlatformTask, Unit>(this){
            final /* synthetic */ TaskCompiler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PlatformExecutor.PlatformTask $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                long seconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - TaskCompiler.access$getTime$p(this.this$0));
                if (seconds > 0L) {
                    Object[] objectArray = new Object[]{seconds};
                    LangKt.sendLang((ProxyCommandSender)TaskCompiler.access$getSender$p(this.this$0), (String)"command-script-compile-wait", (Object[])objectArray);
                }
            }
        }), (int)1, null);
        this.future.thenAccept(arg_0 -> TaskCompiler.startLogger$lambda$4((Function1)new Function1<ScriptCompiled, Unit>(task2){
            final /* synthetic */ PlatformExecutor.PlatformTask $task;
            {
                this.$task = $task;
                super(1);
            }

            public final void invoke(@Nullable ScriptCompiled it) {
                this.$task.cancel();
            }
        }, arg_0));
    }

    private static final void apply$lambda$3$lambda$0(TaskCompiler this$0, ScriptResult.Diagnostic r) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Artifex.INSTANCE.api().getScriptHelper().printScriptResult(r, this$0.sender, this$0.detailError);
    }

    private static final void apply$lambda$3$lambda$1(TaskCompiler this$0, ScriptCompiled script) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (this$0.loggingCompile) {
            Object[] objectArray = new Object[]{TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this$0.time)};
            LangKt.sendLang((ProxyCommandSender)this$0.sender, (String)"command-script-compile-successful", (Object[])objectArray);
        }
        this$0.future.complete(script);
    }

    private static final void apply$lambda$3$lambda$2(TaskCompiler this$0, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (this$0.loggingCompile) {
            Object[] objectArray = new Object[]{TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this$0.time)};
            LangKt.sendLang((ProxyCommandSender)this$0.sender, (String)"command-script-compile-failed", (Object[])objectArray);
            if (!(ex instanceof ScriptCompileFailedException)) {
                ex.printStackTrace();
            }
        }
        this$0.future.complete(null);
    }

    private static final void apply$lambda$3(TaskCompiler this$0, ScriptRuntimeProperty $property, Consumer $report, ScriptCompiler.Compiler it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$property, (String)"$property");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.source(this$0.script);
        it.configuration($property);
        if ($report != null) {
            it.onReport($report);
        } else {
            it.onReport(arg_0 -> TaskCompiler.apply$lambda$3$lambda$0(this$0, arg_0));
        }
        it.onSuccess(arg_0 -> TaskCompiler.apply$lambda$3$lambda$1(this$0, arg_0));
        it.onFailure(arg_0 -> TaskCompiler.apply$lambda$3$lambda$2(this$0, arg_0));
    }

    private static final void startLogger$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$getTime$p(TaskCompiler $this) {
        return $this.time;
    }

    public static final /* synthetic */ ProxyCommandSender access$getSender$p(TaskCompiler $this) {
        return $this.sender;
    }
}

